### InstantiateArgumentExceptionCorrectlyRule
This rule will fire if the arguments to the **System.ArgumentException**, **System.ArgumentNullException**, **System.ArgumentOutOfRangeException**, and **System.DuplicateWaitObjectException** constructors are used incorrectly. This is a common mistake because the position of the **parameterName** argument is not consistent across these types.

**Bad** example:

``` csharp
public void Show (string s)
{
    if (s == null) {
        // the first argument should be the parameter name
        throw new ArgumentNullException ("string is null", "s");
    }
    if (s.Length == 0) {
        // the second argument should be the parameter name
        return new ArgumentException ("s", "string is empty");
    }
    Console.WriteLine (s);
}
```
**Good** example:

``` csharp
public void Show (string s)
{
    if (s == null) {
        throw new ArgumentNullException ("s", "string is null");
    }
    if (s.Length == 0) {
        return new ArgumentException ("string is empty", "s");
    }
    Console.WriteLine (s);
}
```
**Notes**

-   This rule is available since Gendarme 2.2
