### InternalNamespacesShouldNotExposeTypesRule
This rule checks for externally visible types that reside inside internal namespaces, i.e. namespaces ending with **Internal** or **Impl**.

**Bad** example:

``` csharp
namespace MyStuff.Internal {
    public class Helper {
    }
}
```
**Good** example (internal type):

``` csharp
namespace MyStuff.Internal {
    internal class Helper {
    }
}
```
**Good** example (non-internal namespace):

``` csharp
namespace MyStuff {
    public class Helper {
    }
}
```