### MethodCanBeMadeStaticRule
This rule checks for methods that do not require anything from the current instance. Those methods can be converted into static methods, which helps a bit with performance (the hidden **this** parameter can be omitted), and clarifies the API.

**Bad** example:

``` csharp
public class Bad {
    private int x, y, z;
 
    bool Valid (int value)
    {
        // no instance members are used
        return (value > 0);
    }
 
    public int X {
        get {
            return x;
        }
        set {
            if (!Valid (value)) {
                throw ArgumentException ("X");
            }
            x = value;
        }
    }
 
    // same for Y and Z
}
```
**Good** example:

``` csharp
public class Good {
    private int x, y, z;
 
    static bool Valid (int value)
    {
        return (value > 0);
    }
 
    // same X (and Y and Z) as before
}
```