### MissingExceptionConstructorsRule
This rule will fire if an exception class is missing one or more of the following constructors:

-   **public E ()** is required for XML serialization. Public access is required in case the assembly uses CAS to prevent reflection on non-public members.
-   **public E (string message)** is a .NET convention.
-   **public E (string message, ..., Exception inner)** is a .NET convention.
-   **(non)public E (SerializationInfo info, StreamingContext context)** is required for binary serialization.

**Bad** example:

``` csharp
public class GeneralException : Exception {
    // access should be public
    private GeneralException ()
    {
    }
}
```
**Good** example:

``` csharp
public class GeneralException : Exception {
    public GeneralException ()
    {
    }
 
    public GeneralException (string message) : base (message)
    {
    }
 
    public GeneralException (string message, Exception inner) : base (message, inner)
    {
    }
 
    protected GeneralException (SerializationInfo info, StreamingContext context) : base (info, context)
    {
    }
}
```
**Notes**

-   This rule is available since Gendarme 2.0
