### NativeFieldsShouldNotBeVisibleRule
This rule checks if a class exposes native fields. Native fields should not be public because you lose control over their lifetime (other code could free the memory or use it after it has been freed).

**Bad** example:

``` csharp
public class HasPublicNativeField {
    public IntPtr NativeField;
}
```
**Good** example (hide):

``` csharp
class HasPrivateNativeField {
    private IntPtr NativeField;
    public void DoSomethingWithNativeField ();
}
```
**Good** example (read-only):

``` csharp
class HasReadOnlyNativeField {
    public readonly IntPtr NativeField;
}
```