### NonConstantStaticFieldsShouldNotBeVisibleRule
This rule warns if a non-constant public static field is found. In a multi-threaded environment access to those fields must be synchronized.

**Bad** example:

``` csharp
class HasPublicStaticField {
    public static ComplexObject Field;
}
```
**Good** example:

``` csharp
class FieldIsReadonly {
    public readonly static ComplexObject Field = new ComplexObject();
}
```
``` csharp
class UseThreadStatic {
    [ThreadStatic]
    public static ComplexObject Field;
 
    public static InitializeThread ()
    {
        if (Field == null)
        Field = new ComplexObject ();
    }
}
```