### OnlyUseDisposeForIDisposableTypesRule
To avoid confusing developers methods named Dispose should be reserved for types that implement IDisposable.

**Bad** example:

``` csharp
internal sealed class Worker
{
    // This class uses one or more temporary files to do its work.
    private List<string> files = new List<string> ();
 
    // This is confusing: developers will think they can do things
    // like use the instance with a using statement.
    public void Dispose ()
    {
        foreach (string path in files) {
            File.Delete (path);
        }
 
        files.Clear ();
    }
}
```
**Good** example:

``` csharp
internal sealed class Worker
{
    // This class uses one or more temporary files to do its work.
    private List<string> files = new List<string> ();
 
    public void Reset ()
    {
        foreach (string path in files) {
            File.Delete (path);
        }
 
        files.Clear ();
    }
}
```
**Notes**

-   This rule is available since Gendarme 2.6
