### OperatorEqualsShouldBeOverloadedRule
This rule fires if a type overloads operator add **+**, or overloads operator subtract **-**, or is a value type and overrides **Object.Equals**, but equals **==** is not overloaded.

**Bad** example (add/substract):

``` csharp
class DoesNotOverloadOperatorEquals {
    public static int operator + (DoesNotOverloadOperatorEquals a)
    {
        return 0;
    }
 
    public static int operator - (DoesNotOverloadOperatorEquals a)
    {
        return 0;
    }
}
```
**Bad** example (value type):

``` csharp
struct OverridesEquals {
    public override bool Equals (object obj)
    {
        return base.Equals (obj);
    }
}
```
**Good** example:

``` csharp
struct OverloadsOperatorEquals {
    public static int operator + (OverloadsOperatorEquals a)
    {
        return 0;
    }
 
    public static int operator - (OverloadsOperatorEquals a)
    {
        return 0;
    }
 
    public static bool operator == (OverloadsOperatorEquals a, OverloadsOperatorEquals b)
    {
        return a.Equals (b);
    }
 
    public override bool Equals (object obj)
    {
        return base.Equals (obj);
    }
}
```