### ParameterNamesShouldMatchOverriddenMethodRule
This rule warns if an overriden method's parameter names does not match those of the base class or those of the implemented interface. This can be confusing because it may not always be clear that it is an override or implementation of an interface method. It also makes it more difficult to use the method with languages that support named parameters (like C# 4.0).

**Bad** example:

``` csharp
public class Base {
    public abstract void Write (string text);
}
 
public class SubType : Base {
    public override void Write (string output)
    {
        //...
    }
}
```
**Good** example:

``` csharp
public class Base {
    public abstract void Write (string text);
}
 
class SubType : Base {
    public override void Write (string text)
    {
        //...
    }
}
```