### PreferCharOverloadRule
This rule looks for calls to **String** methods that use **String**parameters when a **Char** parameter could have been used. Using the **Char** overload is preferred because it will be faster. Note, however, that this may result in subtly different behavior on versions of .NET before 4.0: the string overloads do a culture based comparison using **CultureInfo.CurrentCulture** and the char methods do an ordinal comparison (a simple compare of the character values). This can result in a change of behavior (for example the two can produce different results when precomposed characters are used). If this is important it is best to use an overload that allows StringComparison or CultureInfo to be explicitly specified see [[1]](http://msdn.microsoft.com/en-us/library/ms973919.aspx#stringsinnet20_topic4) for more details. With .NET 4.0 **String'**s behavior will change and the various methods will be made more consistent. In particular the comparison methods will be changed so that they all default to doing an ordinal comparison.

**Bad** example:

``` csharp
if (s.IndexOf (":") == -1) {
    Console.WriteLine ("no separator found");
}
```
**Good** example:

``` csharp
if (s.IndexOf (':') == -1) {
    Console.WriteLine ("no separator found");
}
```
**Notes**

-   This rule is available since Gendarme 2.4
