### ProvideCorrectRegexPatternRule
This rule verifies that valid regular expression strings are used as arguments.

**Bad** example:

``` csharp
//Invalid end of pattern
Regex re = new Regex ("^\\");
```
**Good** example:

``` csharp
Regex re = new Regex (@"^\\");
```
**Bad** example:

``` csharp
//Unterminated [] set
Regex re = new Regex ("([a-z)*");
```
**Good** example:

``` csharp
Regex re = new Regex ("([a-z])*");
```
**Bad** example:

``` csharp
//Reference to undefined group number 2
return Regex.IsMatch (code, @"(\w)-\2");
```
**Good** example:

``` csharp
return Regex.IsMatch (code, @"(\w)-\1");
```
**Notes**

-   This rule is available since Gendarme 2.4
