### RemoveUnneededFinalizerRule
This rule looks for types that have an empty finalizer (a.k.a. destructor in C# or **Finalize** method). Finalizers that simply set fields to null are considered to be empty because this does not help the garbage collection. You should remove the empty finalizer to alleviate pressure on the garbage collector and finalizer thread.

**Bad** example (empty):

``` csharp
class Bad {
    ~Bad ()
    {
    }
}
```
**Bad** example (only nulls fields):

``` csharp
class Bad {
    object o;
 
    ~Bad ()
    {
        o = null;
    }
}
```
**Good** example:

``` csharp
class Good {
    object o;
}
```
**Notes**

-   Prior to Gendarme 2.2 this rule was named EmptyDestructorRule
