### ReviewCastOnIntegerDivisionRule
This rule checks for integral divisions where the result is cast to a floating point type. It's usually best to instead cast an operand to the floating point type so that the result is not truncated.

**Bad** example:

``` csharp
public double Bad (int a, int b)
{
    // integers are divided, then the result is casted into a double
    // i.e. Bad (5, 2) == 2.0d
    return a / b;
}
```
**Good** example:

``` csharp
public double Good (int a, int b)
{
    // a double is divided by an integer, which result in a double result
    // i.e. Good (5, 2) == 2.5d
    return (double) a / b;
}
```
**Notes**

-   This rule is available since Gendarme 2.2
