### ReviewCastOnIntegerMultiplicationRule
This rule checks for integral multiply operations where the result is cast to a larger integral type. It's safer instead to cast an operand to the larger type to minimize the chance of overflow.

**Bad** example:

``` csharp
public long Bad (int a, int b)
{
    // e.g. Bad (Int32.MaxInt, Int32.MaxInt) == 1
    return a * b;
}
```
**Good** example:

``` csharp
public long Good (int a, int b)
{
    // e.g. Good (Int32.MaxInt, Int32.MaxInt) == 4611686014132420609
    return (long) a * b;
}
```
**Notes**

-   This rule is available since Gendarme 2.2
