### ReviewDoubleAssignmentRule
This rule checks for variables or fields that are assigned multiple times using the same value. This won't change the value of the variable (or fields) but should be reviewed since it could be a typo that hides a real issue in the code.

**Bad** example:

``` csharp
public class Bad {
    private int x, y;
 
    public Bad (int value)
    {
        // x is assigned twice, but y is not assigned
        x = x = value;
    }
}
```
**Good** example:

``` csharp
public class Good {
    private int x, y;
 
    public Good (int value)
    {
        // x = y = value; was the original meaning but since it's confusing...
        x = value;
        y = value;
    }
}
```
**Notes**

-   This rule is available since Gendarme 2.0
