### ReviewLockUsedOnlyForOperationsOnVariablesRule
This rule checks if a lock is used only to perform operations on locals or fields. If the only purpose of that critical section is to make sure the variables are modified atomatically then the methods provided by System.Threading.Interlocked class will be more efficient.

**Bad** example:

``` csharp
lock (_lockObject) {
    _counter++;
}
```
**Good** example:

``` csharp
Interlocked.Increment(_counter);
```
**Bad** example:

``` csharp
lock (_lockObject) {
    _someSharedObject = anotherObject;
}
```
**Good** example:

``` csharp
Interlocked.Exchange(_someSharedObject, anotherObject);
```