### ReviewSelfAssignmentRule
This rule checks for variables or fields that are assigned to themselves. This won't change the value of the variable (or fields) but should be reviewed since it could be a typo that hides a real issue in the code.

**Bad** example:

``` csharp
public class Bad {
    private int value;
 
    public Bad (int value)
    {
        // argument is assigned to itself, this.value is unchanged
        value = value;
    }
}
```
**Good** example:

``` csharp
public class Good {
    private int value;
 
    public Good (int value)
    {
        this.value = value;
    }
}
```
**Notes**

-   This rule is available since Gendarme 2.0
