### ReviewSuppressUnmanagedCodeSecurityUsageRule
This rule fires if a type or method is decorated with the **[SuppressUnmanagedCodeSecurity]**attribute. This attribute reduces the security checks done when executing unmanaged code and its usage should be reviewed to confirm that no exploitable security holes are present.

Example:

``` csharp
[SuppressUnmanagedCodeSecurity]
public class Safe {
    [DllImport ("User32.dll")]
    static extern Boolean MessageBeep (UInt32 beepType);
}
```
**Notes**

-   This is an Audit rule. As such it does not check for valid or invalid patterns but warns about a specific problem that needs to be reviewed by someone.
