### ReviewUseOfModuloOneOnIntegersRule
This rule checks for a modulo one (1) operation on an integral type. This is most likely a typo since the result is always 0. This usually happen when someone confuses a bitwise operation with a remainder.

**Bad** example:

``` csharp
public bool IsOdd (int i)
{
    return ((i % 1) == 1);
}
```
**Good** example:

``` csharp
public bool IsOdd (int i)
{
    return ((i % 2) != 0); // or ((x & 1) == 1)
}
```
**Notes**

-   This rule is available since Gendarme 2.0
