### SecureGetObjectDataOverridesRule
This rule fires if a type implements **System.Runtime.Serialization.ISerializable**but the **GetObjectData** method is not protected with a **Demand** or **LinkDemand** for **SerializationFormatter**.

**Bad** example:

``` csharp
public class Bad : ISerializable {
    public override void GetObjectData (SerializationInfo info, StreamingContext context)
    {
    }
}
```
**Good** example:

``` csharp
public class Good : ISerializable {
    [SecurityPermission (SecurityAction.LinkDemand, SerializationFormatter = true)]
    public override void GetObjectData (SerializationInfo info, StreamingContext context)
    {
    }
}
```
**Notes**

-   Before Gendarme 2.2 this rule was part of Gendarme.Rules.Security.

Feedback
========
Please report any documentation errors, typos or suggestions to the [Gendarme Google Group](http://groups.google.com/group/gendarme). Thanks!
