### TypesWithDisposableFieldsShouldBeDisposableRule
This rule will fire if a type contains disposable fields but does not implement **System.IDisposable**.

**Bad** examples:

``` csharp
class DoesNotImplementIDisposable {
    IDisposable field;
}
 
class AbstractDispose : IDisposable {
    IDisposable field;
 
    // the field should be disposed in the type that declares it
    public abstract void Dispose ();
}
```
**Good** example:

``` csharp
class Dispose : IDisposable {
    IDisposable field;
 
    public void Dispose ()
    {
        field.Dispose ();
    }
}
```