### TypesWithNativeFieldsShouldBeDisposableRule
This rule will fire if a type contains **IntPtr**, **UIntPtr**, or **HandleRef** fields but does not implement **System.IDisposable**.

**Bad** examples:

``` csharp
public class DoesNotImplementIDisposable {
    IntPtr field;
}
 
abstract public class AbstractDispose : IDisposable {
    IntPtr field;
 
    // the field should be disposed in the type that declares it
    public abstract void Dispose ();
}
```
**Good** example:

``` csharp
public class Dispose : IDisposable {
    IDisposable field;
 
    public void Dispose ()
    {
        UnmanagedFree (field);
    }
}
```