### UseCorrectCasingRule
This rule ensures that identifiers are correctly cased. In particular:

-   namespace names are PascalCased
-   type names are PascalCased
-   method names are PascalCased
-   parameter names are camelCased

**Bad** example:

``` csharp
namespace A {
    abstract public class myClass {
        abstract public int thisMethod (int ThatParameter);
    }
}
```
**Good** example:

``` csharp
namespace Company.Product.Technology {
    abstract public class MyClass {
        abstract public int ThisMethod (int thatParameter);
    }
}
```