### UseCorrectPrefixRule
This rule ensures that types are prefixed correctly. Interfaces should always be prefixed with a **I**, types should never be prefixed with a **C** (reminder for MFC folks) and generic parameters should be a single, uppercased letter or be prefixed with **T**.

**Bad** examples:

``` csharp
public interface Phone {
    // ...
}
 
public class CPhone : Phone {
    // ...
}
 
public class Call<Mechanism> {
    // ...
}
```
**Good** examples:

``` csharp
public interface IPhone {
    // ...
}
 
public class Phone : IPhone {
    // ...
}
 
public class Call<TMechanism> {
    // ...
}
```