### UseCorrectSuffixRule
This rule ensure that types that inherit from certain types or implement certain interfaces have a specific suffix. It also ensures that no other types are using those suffixes without inheriting/implementing the types/interfaces. E.g.

-   **System.Attribute** should end with **Attribute**
-   **System.EventArgs** should end with **EventArgs**
-   **System.Exception** should end with **Exception**
-   **System.Collections.Queue** should end with **Collection** or **Queue**
-   **System.Collections.Stack** should end with **Collection** or **Stack**
-   **System.Data.DataSet** should end with **DataSet**
-   **System.Data.DataTable** should end with **DataTable** or **Collection**
-   **System.IO.Stream** should end with **Stream**
-   **System.Security.IPermission** should end with **Permission**
-   **System.Security.Policy.IMembershipCondition** should end with **Condition**
-   **System.Collections.IDictionary** or **System.Collections.Generic.IDictionary** should end with **Dictionary**
-   **System.Collections.ICollection**, **System.Collections.Generic.ICollection** or **System.Collections.IEnumerable** should end with **Collection**

**Bad** example:

``` csharp
public sealed class SpecialCode : Attribute {
    // ...
}
```
**Good** example:

``` csharp
public sealed class SpecialCodeAttribute : Attribute {
    // ...
}
```