### UseFlagsAttributeRule
This rule will fire if an enum's values look like they are intended to be composed together with the bitwise OR operator and the enum is not decorated with **System.FlagsAttribute**. Using **FlagsAttribute** will allow **System.Enum.ToString()** to return a better string when values are ORed together and helps indicate to readers of the code the intended usage of the enum.

**Bad** example:

``` csharp
[Serializable]
enum Options {
    First = 1,
    Second = 2,
    Third = 4,
    All = First | Second | Third,
}
```
**Good** example:

``` csharp
[Flags]
[Serializable]
enum Options {
    First = 1,
    Second = 2,
    Third = 4,
    All = First | Second | Third,
}
```
**Notes**

-   This rule is available since Gendarme 2.6

Feedback
========
Please report any documentation errors, typos or suggestions to the [Gendarme Google Group](http://groups.google.com/group/gendarme). Thanks!
