### UseIsOperatorRule
This rule looks for complex cast operations (e.g. a **as**with a **null** check) that can be simplified using the **is** operator (C# syntax). Note: in some case a compiler, like [g]mcs, can optimize the code and generate IL identical to a **is** operator. In this case the rule will not report an error even if you could see one while looking the at source code.

**Bad** example:

``` csharp
bool is_my_type = (my_instance as MyType) != null;
```
**Good** example:

``` csharp
bool is_my_type = (my_instance is MyType);
```
**Notes**

-   This rule is available since Gendarme 2.0
