### UsePreferredTermsRule
This rule ensures that identifiers such as assemblies, namespaces, types, and members, use the terms suggested by the .NET framework guidelines so that they are consistent with other class libraries.

-   **Arent** should be replaced with **AreNot**;
-   **Cancelled** should be replaced with **Canceled**;
-   **Cant** should be replaced with **Cannot**;
-   **ComPlus** should be replaced with **EnterpriseServices**;
-   **Couldnt** should be replaced with **CouldNot**;
-   **Didnt** should be replaced with **DidNot**;
-   **Doesnt** should be replaced with **DoesNot**;
-   **Dont** should be replaced with **DoNot**;
-   **Hadnt** should be replaced with **HadNot**;
-   **Hasnt** should be replaced with **HasNot**;
-   **Havent** should be replaced with **HaveNot**;
-   **Indices** should be replaced with **Indexes**;
-   **Isnt** should be replaced with **IsNot**;
-   **LogIn** should be replaced with **LogOn**;
-   **LogOut** should be replaced with **LogOff**;
-   **Shouldnt** should be replaced with **ShouldNot**;
-   **SignOn** should be replaced with **SignIn**;
-   **SignOff** should be replaced with **SignOut**;
-   **Wasnt** should be replaced with **WasNot**;
-   **Werent** should be replaced with **WereNot**;
-   **Wont** should be replaced with **WillNot**;
-   **Wouldnt** should be replaced with **WouldNot**;
-   **Writeable** should be replaced with **Writable**;

**Bad** example:

``` csharp
abstract public class ComPlusSecurity {
    abstract public void LogIn ();
    abstract public void LogOut ();
}
```
**Good** example:

``` csharp
abstract public class EnterpriseServicesSecurity {
    abstract public void LogOn ();
    abstract public void LogOff ();
}
```