### UseTypeEmptyTypesRule
This rule fires if a zero length array of **System.Type** is created. This value is so often required by the framework API that the **System.Type** includes an **EmptyTypes** field. Using this field avoids the memory allocation (and GC tracking) of your own array.

**Bad** example:

``` csharp
ConstructorInfo ci = type.GetConstructor (new Type[0]);
```
**Good** example:

``` csharp
ConstructorInfo ci = type.GetConstructor (Type.EmptyTypes);
```
**Notes**

-   This rule is available since Gendarme 2.0

Feedback
========
Please report any documentation errors, typos or suggestions to the [Gendarme Google Group](http://groups.google.com/group/gendarme). Thanks!
