### WriteStaticFieldFromInstanceMethodRule
This rule is used to check for instance methods which write values to static fields. This may cause problems if multiple instances of the type exist and are used in multithreaded applications.

**Bad** example:

``` csharp
static int default_value;
 
public int Value {
    get {
        if (default_value == 0) {
            default_value = -1;
        }
        return (value > default_value) ? value : 0;
    }
}
```
**Good** example:

``` csharp
static int default_value = -1;
 
public int Value {
    get {
        return (value > default_value) ? value : 0;
    }
}
```
Feedback
========
Please report any documentation errors, typos or suggestions to the [Gendarme Google Group](http://groups.google.com/group/gendarme). Thanks!
