## Always tag the version of an image explicitly.

### Problematic code:

```dockerfile
FROM debian
```

### Correct code:

```dockerfile
FROM debian:jessie
```
### Rationale:

You can never rely that the `latest` tags is a specific version.

https://docs.docker.com/engine/userguide/dockerimages/

> Tip: You recommend you always use a specific tagged image, for example ubuntu:12.04. That way you always know exactly what variant of an image is being used.

### Exceptions:

When the image name refers to a previously defined alias:

```dockerfile
FROM debian:jessie as build

RUN build_script

FROM build as tests

RUN test_script

FROM debian:jessie

COPY --from=build foo .
```