## Pin versions in apt get install.

### Problematic code:

```dockerfile
FROM busybox
RUN apt-get install python
```

### Correct code:

```dockerfile
FROM busybox
RUN apt-get install python=2.7
```
### Rationale:

https://docs.docker.com/engine/articles/dockerfile_best-practices/

> Version pinning forces the build to retrieve a particular version regardless of what’s in the cache. This technique can also reduce failures due to unanticipated changes in required packages.