Declaring a variable as both nonlocal and global is not possible and it's a syntax error.

A variable can be declared as global when you want to modify its value from a different scope
than the one it was defined into, as seen in the following example:

    a = 42

    def modify_a():
        global a
        a = 24


The nonlocal statement can be used to refer identifiers to previously bound variables in the nearest enclosing scope excluding globals.
Here's how you might use it to modify a variable found into the nearest enclosing scope.

    def foo():
        value = 42
        def modify_value():
            nonlocal value
            value = 24
        modify_value()

[SOURCE](https://docs.python.org/3/reference/simple_stmts.html#the-global-statement)