Enforces the correct signatures of special methods, which are the
methods that the interpreter uses for implementing syntactic sugar
on top of them.

For example, in the following example, __exit__() should have
three parameters, the type, the value and the traceback if
the body of the with statement raised any errors.
Failing to do so will result in a runtime crash.

    class Manager(object):

        def __enter__(self):
            return self
        def __exit__(self):
            pass