Some programmers consider using several local variables in on function or method is an indicator that the function or method is too complex, or trying to do too much.

Consider a function that does several things:

	def process_thing(thing):
	    # print an outline of the thing header
	    ...

	    # calculate some statistics about the thing
	    ...

	    # print reports on those statistics
	   ...

Each of these comments indicates a place where a separate function could be used:


	def summarize_thing(thing):
	    "prints a summary"
	    ...

	def get_usage_statistics(thing):
	    "creates a block of information"
	    ....
	    return stats_block

	def print_stats(stats_block):
	    "pretty charts and stuff"
	    ...

	def process_thing(thing):
	    summarize_thing(thing)
	    stats = get_usage_statistics(thing)
	    print_stats(stats)


[SOURCE](http://pylint-messages.wikidot.com/messages:R0914)
