Used when an argument is not used in the body of its function or method.

Apart from the obvious solution of using the argument, this message can be avoided by deleting the argument:

	def myfunc(a1, a2):
	    del a2 # unused
	    return a1*2

Other solutions such as renaming the argument to 'unused_a2' or the like are not recommended, because a caller could pass the argument by name:

	def myfunc(a1, unused_a2):
	    return a1*2

	def func2():
	    return myfunc(42, a2=16) # now fails!


[SOURCE](http://pylint-messages.wikidot.com/messages:W0613)
