package codacy.patterns

import codacy.base.Pattern

import scala.meta._

case object Custom_Scala_CommandInjection extends Pattern {

  lazy val methodOffenders: Set[String] = Set(
    "!",
    "!!",
    "!<",
    "run",
    "lineStream_!",
    "lines",
    "lines_!"
  )

  override def apply(tree: Tree) = {

    val runtimeVals: Set[String] = tree.collect {
      case q"""..$_ val $name: $_ = Runtime.getRuntime""" =>
        name.toString
      case q"""..$_ var $name: $_ = Runtime.getRuntime""" =>
        name.toString
      case q"""..$_ val $name: $_ = Runtime.getRuntime()""" =>
        name.toString
      case q"""..$_ var $name: $_ = Runtime.getRuntime()""" =>
        name.toString
    }.toSet[String]

    val pbVals: Set[String] = tree.collect {
      case t@q"""..$_ val $name: $_ = new $expr""" if isProcessBuilder(expr) =>
        name.toString
      case t@q"""..$_ val $name: $_ = new $expr with ..$inits { $self => ..$stats }""" if isProcessBuilder(expr) =>
        name.toString
    }.toSet[String]

    tree.collect {
      case t@q"..$mods def $ename[..$tparams](...$paramss): $tpeopt = $expr" =>
        findOffendersInScope(expr, paramss.flatten, runtimeVals, pbVals)

      case t@q"..$mods class $tname[..$tparams] ..$ctorMods (...$paramss) extends $template" =>
        findOffendersInScope(template, paramss.flatten, runtimeVals, pbVals)
    }.flatten
  }


  private[this] def extractArgSeq(some: Term): Seq[Term] = {
    some match {
      case q"$expr(..${args: Seq[Term]})" =>
        args
      case q"${lit: Term.Name}" =>
        Seq(lit)
      case _ =>
        Seq.empty
    }
  }

  private[this] def findOffendersInScope(tree: Tree, paramsInScope: Seq[Term.Param], runtimeVals: Set[String], pbVals: Set[String]) = {
    tree.collect {
      case t@q"$some.exec(..${args: Seq[Term]})" if runtimeVals.contains(some.toString()) && isOffender(args, paramsInScope) =>
        Result(message, t)
      case t@q"Runtime.getRuntime.exec(..${args: Seq[Term]})" if isOffender(args, paramsInScope) =>
        Result(message, t)
      case t@q"Runtime.getRuntime().exec(..${args: Seq[Term]})" if isOffender(args, paramsInScope) =>
        Result(message, t)

      case t@q"$some.command(..${args: Seq[Term]})" if pbVals.contains(some.toString()) && isOffender(args, paramsInScope) =>
          Result(message, t)
      case t@q"new $init" if isCtorOffender(init, paramsInScope) =>
        Result(message, t)

      case t@q"${some: Term}.${method: Term.Name}" if isOffender(extractArgSeq(some), paramsInScope) && methodOffenders.contains(method.toString) =>
        Result(message, t)
    }
  }

  private[this] def isCtorOffender(ctorCalls: Init, paramsInScope: Seq[Term.Param]): Boolean = {
    ctorCalls match {
      case init"$ctorname(..$params)" if isOffender(params, paramsInScope) =>
        (ctorname.toString == "ProcessBuilder" || ctorname.toString == "java.lang.ProcessBuilder") && isOffender(params, paramsInScope)
      case _ =>
        false
    }
  }

  private[this] def isOffender(args: Seq[Term], paramsInScope: Seq[Term.Param]): Boolean = {
    val namesInScope = paramsInScope.collect {
      case param"..$mods ${name: Name}: $_ = $_" =>
        name.value
    }

    //checking common expressions in parameters
    val paramNames = args.flatMap {
      case q"${expr: Term}" =>
        expr match {
          case q"$n1 + $n2($_) + $n3" =>
            Seq(n1.toString(), n2.toString(), n3.toString())
          case q"$n1 + $n2($_)" =>
            Seq(n1.toString(), n2.toString())
          case q"$n1 + $n2 + $n3" =>
            Seq(n1.toString(), n2.toString(), n3.toString())
          case q"$n1 + $n2" =>
            Seq(n1.toString(), n2.toString())
          case q"$name.head" =>
            Seq(name.toString())
          case q"$name($_)" =>
            Seq(name.toString())
          case _ =>
            Seq(expr.toString())
        }
    }

    paramNames.exists(param => namesInScope.contains(param))
  }

  private[this] def isProcessBuilder(expr: Tree): Boolean = {
    expr match {
      case init"$ctorname(..$args)" =>
        ctorname.toString == "ProcessBuilder" || ctorname.toString == "java.lang.ProcessBuilder"
      case init"$ctorname" =>
        ctorname.toString == "ProcessBuilder" || ctorname.toString == "java.lang.ProcessBuilder"
      case _ =>
        false
    }
  }

  private[this] def message = Message("Potential Command Injection")
}