package codacy.patterns

import codacy.base.Pattern

import scala.meta._

case object Custom_Scala_ObjDeserialization extends Pattern{

  override def apply(tree: Tree) = {
    tree.collect{
      case t@q"new ObjectInputStream(..$args).readObject()" =>
        Result(message(t),t)
      case t@q"new java.io.ObjectInputStream(..$args).readObject()" =>
        Result(message(t),t)
    }
  }

  private[this] def message(tree: Tree) = Message("Avoid object deserialization of untrusted data")
}