package codacy.patterns

import codacy.base.Pattern

import scala.meta._

case object Custom_Scala_PlayUnvalidatedRedirect extends Pattern {

  override def apply(tree: Tree) = {
    if (hasPlayHint(tree)) {
      tree.collect {
        case tt@q"Redirect(..${args: Seq[Term]})"
          if isInActionExpr(tt) && hasOffender(args) =>
          Result(message, tt)
        case t@q"def $name[..$tparams](...${paramss: Seq[Seq[Term.Param]]}): ${tpeopt: Option[Type]} = Redirect(..${args: Seq[Term]})"
          if tpeopt.exists(isActionTpe) && args.exists(isOffender) =>
          Result(message, t)
      }
    }
    else {
      Seq.empty
    }
  }

  private[this] def isActionTpe(tpe: Type): Boolean = {
    tpe match {
      case t"${tpe: Type.Name}[..$tpesnel]" =>
        tpe.value == "Action"
      case _ =>
        false
    }
  }

  private[this] def hasOffender(args: Seq[Term]): Boolean = {
    args.exists(isOffender)
  }

  private[this] def isUnvalidatedParam(param: Term.Param, arg: Term): Boolean = {
    param match {
      case param"..$mods ${paramname: Term.Name}: $atpeopt = $exprop" =>
        paramname.value == arg.toString()
      case _ => false
    }
  }

  private[this] def isOffender(arg: Term): Boolean = {
    determineScopeParams(arg).exists { case params =>
      params.exists(param => isUnvalidatedParam(param, arg))
    }
  }

  private[this] def determineScopeParams(node: Tree): Option[Seq[Term.Param]] = {
    node match {
      case t@q"..$mods def $name[..$tparams](...${paramss: Seq[Seq[Term.Param]]}): $tpeopt = $expr" => Some(paramss.flatten)
      case source"..$stats" => Option.empty
      case item => item.parent.flatMap(determineScopeParams)
    }
  }

  //are we on the rhs of a Handler(Action)?
  private[this] def isInActionExpr(tree: Tree): Boolean = {
    (tree, tree.parent) match {
      case (_: Defn.Def, _) =>
        false
      case (q"Action(..$aexprssnel){ ..$stats }", _) =>
        true
      case (q"Action.async(..$aexprssnel){ ..$stats }", Some(_)) =>
        true
      case (q"Action{..$stats}", Some(_)) =>
        true
      case (_, Some(parent)) =>
        isInActionExpr(parent)
      case _ =>
        false
    }
  }

  //this is merely to avoid false positives remove it if the pattern never encounters issues
  private[this] def hasPlayHint(tree: Tree): Boolean = {
    tree.collect {
      case importer"play.api.mvc._" => true
    }.exists(identity)
  }

  private[this] def message = Message("Unvalidated redirect parameter.")

}
