package codacy.patterns

import codacy.base.Pattern

import scala.meta._

object Custom_Scala_SprayHttpHeaderHost extends Pattern {

  //we see a lot of backticks in spray headers
  private[this] lazy val headerName = "Host"
  private[this] lazy val headerTypeNames = Set(headerName,s"`$headerName`")

  override def apply(tree: Tree) = {
    lazy val importsHeader = importsSprayHostHeader(tree)
    if(hasSprayHint(tree)){
      tree.collect{
        case t@q"""headerValueByName(${lit: Lit})""" if lit.value == headerName =>
          Result(message(t),t)
        case t@q"""optionalHeaderValueByName(${lit: Lit})""" if lit.value == headerName =>
          Result(message(t),t)
        case t@q"headerValueByType[$tpe]" if isHostHeaderType(tpe,importsHeader) =>
          Result(message(t),t)
        case t@q"optionalHeaderValueByType[$tpe]" if isHostHeaderType(tpe,importsHeader) =>
          Result(message(t),t)
        case p"case ${pat:Pat} if $expropt => $expr" if hasHostType(pat) =>
          Result(message(pat),pat)
      }
    }
    else Seq.empty
  }

  private[this] def isHostHeaderType(tree:Type, importsHeader: => Boolean):Boolean = {
    Option(tree).exists{
      case t"$eref.$tname" =>
        eref.toString == "HttpHeaders" && tname.toString == headerName
      case t"${name: Type.Name}" =>
        name.toString == headerName && importsHeader
      case _ => false
    }
  }

  //this is merely to avoid false positives remove it if the pattern never encounters issues
  private[this] def hasSprayHint(tree:Tree):Boolean = {
    tree.collect{
      case importer"spray.http._" => true
    }.exists(identity)
  }

  private[this] def hasHostType(pat:Pat):Boolean = {
    pat.collect{
      case q"${name: Term.Name}" =>
        headerTypeNames.exists(_ == name.toString)
      case q"${name: Type.Name}" =>
        headerTypeNames.exists(_ == name.toString)
    }.exists(identity)
  }

  private[this] def importsSprayHostHeader(tree:Tree):Boolean = {
    tree.collect{
      case t@importer"$ref.{..${importeesnel:Seq[Importee]}}" =>
        Option(ref).exists{
          case q"spray.http.HttpHeaders" => true
          case _ => false
        } && importeesnel.exists{
          case importee"${iname:Name}" =>
            headerTypeNames.exists(_ == iname.toString)
          case importee"_" => true
          case _ => false
        }
    }.exists(identity)
  }

  private[this] def message(tree:Tree) = Message("Depending on the hostname header is considered insecure")
}
