package codacy.patterns

import codacy.base.Pattern

import scala.meta._

case object Custom_Scala_SprayHttpHeaderReferer extends Pattern{

  //we see a lot of backticks in spray headers
  private[this] lazy val headerName = "Referer"

  override def apply(tree: Tree) = {
    if(hasSprayHint(tree)){
      tree.collect{
        case t@q"""headerValueByName(${lit: Lit})""" if lit.value == headerName =>
          Result(message(t),t)
        case t@q"""optionalHeaderValueByName(${lit: Lit})""" if lit.value == headerName =>
          Result(message(t),t)
      }
    }
    else Seq.empty
  }

  //this is merely to avoid false positives remove it if the pattern never encounters issues
  private[this] def hasSprayHint(tree:Tree):Boolean = {
    tree.collect{
      case importer"spray.http._" => true
    }.exists(identity)
  }

  private[this] def message(tree:Tree) = Message("Depending on the 'Referer' header is considered insecure")

}