package codacy.patterns

import codacy.base.Pattern

import scala.meta._
import scala.util.Try

case object Custom_Scala_WeakCustomDigest extends Pattern {

  override def apply(tree: Tree) = {
    tree.collect {
      case t@template"{ ..$_ } with ..${ctorcalls: Seq[Init]} { $_ => ..$_ }"
        if isOffender(ctorcalls) =>
        Result(message, t)
    }
  }

  private def isOffender(ctorCalls: Seq[Init]): Boolean = {
    ctorCalls.collect {
      case t@init"${ctorname: Type}(..$_)" =>
        Try(ctorname.toString.split('.').last).getOrElse(ctorname)
    }.contains("MessageDigest")
  }

  private def message = Message("Message digest is Custom")
}
