package codacy.patterns

import codacy.base.Pattern

import scala.meta._
import scala.util.{Failure, Success, Try}
import scala.xml._

case object Custom_Scala_XSSescapeXml extends Pattern{

  override def apply(tree: Tree) = {
    tree.collect{
      //TODO: xml is not officially supported by scala.meta yet so we might have to change it in future versions
      case Term.Interpolate(Term.Name("xml"),lits,_) =>
        lits.collect{ case t@Lit(value:String) if isEvilXml(value) =>
          Result(message(t),t)
        }
      case t@Lit(raw:String) if isEvilXml(raw) =>
        List(Result(message(t),t))
    }.flatten.toSet
  }

  private[this] def isEvilXml(raw:String):Boolean = {
    Try(XML.loadString(raw)) match{
      case Success(elem) =>
        elem.exists(hasEvilMetadata)
      case Failure(err) => false
    }
  }

  private[this] def hasEvilMetadata(node:Node):Boolean = {
    node.attributes.exists{
      case metaData if metaData.key == "escapeXml" =>
        metaData.value.exists{
          case text:Text => text.data == "false"
          case _ => false
        }
      case _ => false
    }
  }

  private[this] def message(tree: Tree) = Message("Potential XSS")
}