//#Patterns: Custom_Scala_PlayUnvalidatedRedirect
package controllers

import play.api.mvc._
import play.api.libs.json._

import scala.concurrent.Future

class Application extends Controller {

  //fine
  def index = Action {
    val list = List(1, 2, 3)
    Redirect(Json.toJson(list))
  }

  //#Warn: Custom_Scala_PlayUnvalidatedRedirect
  def index2(string: String): Action[AnyContent] = Redirect(string)

  // Maybe modified in a way we can't understand.
  def index2(string: String) = Action {
    Redirect(Json.toJson(string))
  }

  def index3(string:String,int:Int) = Action(parse.json){ req =>
    //#Warn: Custom_Scala_PlayUnvalidatedRedirect
    Redirect(string)
  }
  
  def index5(string:String)(implicit otherParamL:Int) = {
    Action{ req =>
      //#Warn: Custom_Scala_PlayUnvalidatedRedirect
      Redirect(string)
    }
  }

  def index5(string:String) = Action.async(parse.json[String]){ req =>
    //#Warn: Custom_Scala_PlayUnvalidatedRedirect
    Future.successful(Redirect(string))
  }

  //fine
  def index6() = Action.async(parse.json[String]){ req =>
    Future.successful(Redirect("Hello, World!"))
  }

  def index7() = Action.async(parse.json[String]){ req =>
      Redirect(routes.Application.tasks)
  }

}