## `(` is invalid here. Did you forget to escape it?

### Problematic code:

```sh
echo (foo) bar
```

### Correct code:

Depends on your intention:

```sh
echo "(foo) bar"  # Literal parentheses
echo "$(foo) bar" # Command expansion
echo "foo bar"    # Tried to use parentheses for grouping or function invocation
```

### Rationale:

ShellCheck expected an ordinary shell word but found an opening parenthesis instead.

Determine what you intended the parenthesis to do and rewrite accordingly. Common issues include:

* Wanting them to be literal, as in `echo (FAIL) Some tests failed`. In this case, it requires quoting.
* Wanting command expansion, as in `echo Today is (date)`. Add the missing `$`: `echo "Today is $(date)"`
* Adding parentheses because other languages need them in that context, such as `foo (bar, 42)` to call a function. This should be `foo bar 42`. Also, shells do not support tuples or passing arrays as single parameters.

### Exceptions:

None

### Related resources:

* Help by adding links to BashFAQ, StackOverflow, man pages, POSIX, etc!
[Source](https://github.com/koalaman/shellcheck/wiki/SC1036)

