## When using <<-, you can only indent with tabs.

### Problematic code:

Any code using `<<-` that is indented with spaces. `cat -T script` shows

```sh
    cat <<- foo
        Hello world
    foo
```

### Correct code:

Code using `<<-` must be indented with tabs. `cat -T script` shows

```sh
^Icat <<- foo
^I^IHello world
^Ifoo
```

Or simply don't indent the end token:

```sh
    cat <<- foo
      Hello World
foo
```

### Rationale:

`<<-`, by design, only strips tabs. Not spaces.

Your editor may be automatically replacing tabs with spaces, either when you type them or when you save the file or both. If you're unable to make it stop, just don't indent the end token.

### Exceptions

None. But note that copy-pasting code to [shellcheck.net](http://www.shellcheck.net) may also turn correct tabs into spaces on some OS.

[Source](https://github.com/koalaman/shellcheck/wiki/SC1040)

