## This directive is unknown. It will be ignored.

### Problematic code:

```sh
# shellcheck foobar=baz
echo "Hello World"
```

### Correct code:

Depends on your intention.

### Rationale:

ShellCheck doesn't recognize the [[directive]] you're trying to use in a `# shellcheck` comment. See the [[Directive]]s page for supported directives.

It could be misspelled, or you could be using an older version of shellcheck that doesn't support it yet.

### Exceptions:

None. If you wish to ignore this warning and continue without it, you need version 0.4.5 (commit 88c56ec) or later and a command grouping:

```
# Ignore an unrecognized directive in 0.4.5 or later:
# shellcheck disable=SC1107
{
  # shellcheck unrecognized=directive
  echo "Hello World"
}
```

Before 0.4.5, unrecognized directives are considered parse errors.
[Source](https://github.com/koalaman/shellcheck/wiki/SC1107)

