## You need a space before and after the = .

### Problematic code:

```sh
[ "$var"= 2 ]
```

### Correct code:

```sh
[ "$var" = 2 ]
```
### Rationale:

You appear to be missing the space on the left side of the operator. Shell in general, and `[` in particular, is space sensitive. Operators and operands must be separate tokens. 

Please ensure that the operator, like the `=` in the example, has a space both before and after it.

### Exceptions:

None. If you're comparing values in C style reverse order like `[ -eq == $1 ]`, use quotes: `[ "-eq" == "$1" ]`. Also, it's pointless since `[ a = b ]` doesn't assign.
[Source](https://github.com/koalaman/shellcheck/wiki/SC1108)

