# $/${} is unnecessary on arithmetic variables.

### Problematic code:

```sh
echo $(($n+1))
```

### Correct code:

```sh
echo $((n+1))
```

### Rationale:

The `$` on regular variables in arithmetic contexts is unnecessary, and can even lead to subtle bugs. This is because the contents of `$((..))` is first expanded into a string, and then evaluated as an expression:

```sh
$ a='1+1'
$ echo $(($a * 5))    # becomes 1+1*5
6
$ echo $((a * 5))     # evaluates as (1+1)*5
10
```

The `$` is unavoidable for special variables like `$1` vs `1`, `$#` vs `#`. It's also required when adding modifiers to parameters expansions, like `${#var}` or `${var%-}`. ShellCheck does not warn about these cases.

[Source](https://github.com/koalaman/shellcheck/wiki/SC2004)

