# foo appears unused. Verify it or export it.

### Problematic code:

```sh
foo=42
echo "$FOO"
```

### Correct code:

```sh
foo=42
echo "$foo"
```

### Rationale:

Variables not used for anything are often associated with bugs, so ShellCheck warns about them.

Also note that something like `local let foo=42` does not make a `let` statement local -- it instead declares an additional local variable named `let`.

### Exceptions

ShellCheck may not always realize that the variable is in use (especially with indirection), and may not realize you don't care (with throwaway variables or unimplemented features).

For throwaway variables, consider using `_` as a dummy:

```sh
read _ last _ zip _ _ <<< "$str"
echo "$last, $zip"
```

or use a directive to disable the warning:

```sh
# shellcheck disable=SC2034
read first last email zip lat lng <<< "$str"
echo "$last, $zip"
```

For indirection, there's not much you can do without rewriting to use arrays or similar:

```sh
bar=42  # will always appear unused
foo=bar
echo "${!foo}"
```

This is expected behavior, and not a bug. There is no good way to statically analyze indirection in shell scripts, just like static C analyzers have a hard time preventing segfaults.

As always, there are ways to [[ignore]] this and other messages if they frequently get in your way.

[Source](https://github.com/koalaman/shellcheck/wiki/SC2034)

